<Query Kind="Program">
  <Output>DataGrids</Output>
  <Reference Relative="Calendrier.exe">D:\t\Calendrier\Calendrier.exe</Reference>
  <Reference Relative="PdfSharp-WPF.dll">D:\t\Calendrier\PdfSharp-WPF.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\WPF\PresentationCore.dll</Reference>
  <Namespace>Calendrier</Namespace>
  <Namespace>System.Windows.Media</Namespace>
</Query>

void Main()
{
	var events = new List<CalendarPDF.CalendarEvent>();
	var filename = @"d:\t\calendrier\Calendar.pdf";
	var imageFileName = @"D:\t\Calendrier\1527000874638.jfif";
	var targetDate = DateTime.Now.AddDays(5);
	
	events.Add(new CalendarPDF.CalendarEvent(){ EventDate = targetDate, Description = "Événement #1", Color = Colors.Blue});
	events.Add(new CalendarPDF.CalendarEvent(){ EventDate = targetDate, Description = "Événement #2", Color = Colors.Green});
	
	var calendar = new CalendarPDF() { ImageFileName = imageFileName, StartingYear = targetDate.Year, StartingMonth = targetDate.Month, CalendarEvents=events };
	calendar.Save(filename);
	
	var proc = System.Diagnostics.Process.Start(filename);
	while (!proc.HasExited)
	{
		System.Threading.Thread.Sleep(200);
	}
	File.Delete(filename);
}